import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Define the grid size
rows, cols = 4, 3

# Define the colors for clear, occupied, and painted tiles
clear_color = 'lightgreen'
occupied_color = 'salmon'
painted_black_color = 'black'

# Define the robot color
robot_color = 'black'

# Define the tile status
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear',
    'tile_1-1': 'clear', 'tile_1-2': 'clear', 'tile_1-3': 'clear',
    'tile_2-1': 'clear', 'tile_2-2': 'clear', 'tile_2-3': 'clear',
    'tile_3-1': 'occupied', 'tile_3-2': 'painted_black', 'tile_3-3': 'clear',
}

# Define robot position
robot_position = (3, 0)

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if status == 'clear':
            color = clear_color
        elif status == 'occupied':
            color = occupied_color
        elif status == 'painted_black':
            color = painted_black_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='white' if color == painted_black_color else 'black')

# Draw the robot
row, col = robot_position
circle = patches.Circle((col + 0.5, rows-row-0.5), 0.3, edgecolor='black', facecolor=robot_color)
ax.add_patch(circle)
ax.text(col + 0.5, rows-row-0.7, 'robot1', ha='center', va='center', fontsize=8, color='white')

# Draw available colors
available_colors = ['white', 'black']
for i, color in enumerate(available_colors):
    rect = patches.Rectangle((i * 1.5, -1), 1, 0.5, linewidth=1, edgecolor='black', facecolor=color)
    ax.add_patch(rect)
    ax.text(i * 1.5 + 0.5, -0.75, f'color_{color}', ha='center', va='center', fontsize=8, color='black' if color == 'white' else 'white')

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-1.5, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=painted_black_color, edgecolor='black', label='Painted Black Tile'),
    patches.Patch(facecolor=robot_color, edgecolor='black', label='Robot1 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()